<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Google_Map_Contact_Info extends Widget_Base {

    public function get_name() {
        return 'conat_google_map_contact_info';
    }

    public function get_title() {
        return esc_html__( 'Conat Google Map & Contact Info', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		//Google Map
		$this->start_controls_section(
			'google_map',
			[
				'label' => esc_html__( 'Google Map', 'conat' ),
			]
		);
		$this->add_control(
			'google_map_iframe',
			[
				'label' => __( 'Google Map Iframe', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->end_controls_section();
		
		//Contact Info
        $this->start_controls_section(
            'contact_info_tab',
            [
                'label' => esc_html__( 'Contact Info', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'contact_info',
			[
				'label'       => __( 'Contact Info', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Contact Page Section -->
        <section class="contact-page-section-two">
            <div class="auto-container">
                <div class="row clearfix">
                    <!-- Map Column -->
                    <div class="map-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <!--Map Outer-->
                            <div class="map-outer">
                                <?php echo do_shortcode($settings['google_map_iframe']); ?>
                            </div>
                        </div>
                    </div>
                    <!-- Info Column -->
                    <div class="info-column col-lg-6 col-md-12 col-sm-12">
                    	<?php if ($settings['contact_info']){ ?>
                        <div class="inner-column">
                            <ul class="info">
                            	<?php foreach($settings['contact_info'] as $key => $item) { ?>
                                <li><span><?php echo wp_kses( $item['title'], true ); ?></span><?php echo wp_kses( $item['text'], true ); ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                        <?php }  ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Contact Page Section -->
        
        <?php
    }
}
