<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Google_Map extends Widget_Base {

	public function get_name() {
		return 'conat_google_map';
	}

	public function get_title() {
		return esc_html__( 'Conat Google Map', 'conat' );
	}

	public function get_icon() {
        return 'tr-custom-icon';
	}

	public function get_categories() {
		return [ 'conat' ];
	}

	protected function _register_controls() {
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Google Map
		$this->start_controls_section(
			'google_map',
			[
				'label' => esc_html__( 'Google Map', 'conat' ),
			]
		);
		$this->add_control(
			'google_map_iframe',
			[
				'label' => __( 'Google Map Iframe', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>
        
        <!-- Map One -->
        <section class="map-one">
            <div class="auto-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['subtitle'], true ); ?></h2>
                </div>
                
                <?php echo do_shortcode($settings['google_map_iframe']); ?>
            </div>
        </section>
        <!-- End Map One -->
        
		<?php 
	}

}
