<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Gallery_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_gallery_v2';
    }

    public function get_title() {
        return esc_html__( 'Conat Gallery V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'gallery-carousel', TR_URL . 'assets/js/gallery-carousel.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'gallery-carousel' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'gallery_tab',
            [
                'label' => esc_html__( 'Gallery', 'conat' ),
            ]
        );
        $this->add_control(
			'gallery_image',
			[
				'label' => __( 'Gallery Images', 'conat' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Gallery Two -->
        <section class="gallery-two">
            <div class="outer-container">
                <div class="gallery-carousel owl-carousel owl-theme">
                	<?php foreach ( $settings['gallery_image'] as $image ) { ?>
                    <!-- Gallery One Block -->
                    <div class="gallery-one_block">
                        <div class="gallery-one_block-inner">
                            <div class="gallery-one_block-image">
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>">
                                <div class="gallery-one_block-overlay">
                                    <a href="<?php echo esc_url($image['url']); ?>" class="gallery-one_block-icon flaticon-plus-symbol"></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </section>
        <!-- End Gallery Two -->
        
		<?php
    }
}
