<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Gallery_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_gallery_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Gallery V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'gallery_tab',
            [
                'label' => esc_html__( 'Gallery', 'conat' ),
            ]
        );
		$this->add_control(
            'column',
            [
                'label' => esc_html__( 'Column', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => array(
                    '2' => esc_html__( '2', 'conat' ),
                    '3' => esc_html__( '3', 'conat' ),
                    '4' => esc_html__( '4', 'conat' ),
                    '5' => esc_html__( '5', 'conat' ),
                    '6' => esc_html__( '6', 'conat' ),
                ),
            ]
        );
        $this->add_control(
			'gallery_image',
			[
				'label' => __( 'Gallery Images', 'conat' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>

		<!-- Gallery One -->
        <section class="gallery-one">
            <div class="outer-container">
                <div class="clearfix">
                	<?php
					if($settings['column'] == 2)
						$column = 'col-lg-6 col-md-4 col-sm-6';
						
					else if($settings['column'] == 3)
						$column = 'col-lg-4 col-md-4 col-sm-6';
						
					else if($settings['column'] == 4)
						$column = 'col-lg-3 col-md-4 col-sm-6';
						
					else if($settings['column'] == 5)
						$column = 'col-lg-5ths col-md-5ths col-sm-5ths';
						
					else if($settings['column'] == 6)
						$column = 'col-lg-2 col-md-4 col-sm-6';
						
					else
						$column = 'col-lg-3 col-md-4 col-sm-6';
						
					foreach ( $settings['gallery_image'] as $image ) { ?>
                    <!-- Gallery One Block -->
                    <div class="gallery-one_block <?php echo esc_attr($column); ?>">
                        <div class="gallery-one_block-inner">
                            <div class="gallery-one_block-image">
                                <img src="<?php echo esc_url($image['url']); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>">
                                <div class="gallery-one_block-overlay">
                                    <a href="<?php echo esc_url($image['url']); ?>" class="gallery-one_block-icon flaticon-plus-symbol"></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </section>
        <!-- End Gallery One -->
        
		<?php
    }
}
