<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Faqs_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_faqs_v2';
    }

    public function get_title() {
        return esc_html__( 'Conat FAQs V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        //Query
        $this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__('Query', 'conat'),
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label' => esc_html__('Text Limit', 'conat'),
                'type' => Controls_Manager::NUMBER,
                'default' => 35,
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label' => esc_html__('Number of Post', 'conat'),
                'type' => Controls_Manager::NUMBER,
                'default' => 7,
                'min'  => 1,
                'max'  => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label' => esc_html__('Order By', 'conat'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date' => esc_html__('Date', 'conat'),
                    'title'   => esc_html__('Title', 'conat'),
                    'menu_order' => esc_html__('Menu Order', 'conat'),
                    'rand' => esc_html__('Random', 'conat'),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label' => esc_html__('Order', 'conat'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__('DESC', 'conat'),
                    'ASC' => esc_html__('ASC', 'conat'),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'label' => esc_html__('Category', 'conat'),
                'type' => Controls_Manager::SELECT,
                'options' => get_categories_list('faqs_cat')
            ]
        );
        $this->end_controls_section();
		
		//Contact Form
        $this->start_controls_section(
            'contact_tab',
            [
                'label' => esc_html__( 'Contact Form', 'conat' ),
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Form', 'conat'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = get_query_var('paged');
		$paged = conat_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute('wrapper', 'class', 'themerange-conat');
        $args = array(
            'post_type' => 'faqs',
            'posts_per_page' => conat_set($settings, 'query_number'),
            'orderby' => conat_set($settings, 'query_orderby'),
            'order' => conat_set($settings, 'query_order'),
            'paged' => $paged
        );

        if( conat_set($settings, 'query_category') ) $args['faqs_cat'] = conat_set($settings, 'query_category');
        $query = new \WP_Query($args); ?>

		<!-- Faq Two -->
        <section class="faq-two">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="col-lg-6 col-md-12 col-sm-12">
                    	<?php if($query->have_posts()) { ?>
                        <!-- Accordion Box / Style Two -->
                        <ul class="accordion-box style-two">
                            <?php $i=1;
							while ($query->have_posts() ) : $query->the_post(); ?>
                            <!-- Block -->
                            <li class="accordion block <?php if($i==1) echo 'active-block'; ?>">
                                <div class="acc-btn <?php if($i==1) echo 'active'; ?>"><div class="icon-outer"><span class="icon fa-solid fa-angle-down fa-fw"></span></div><?php the_title(); ?></div>
                                <div class="acc-content <?php if($i==1) echo 'current'; ?>">
                                    <div class="content">
                                        <p><?php echo wp_kses(conat_trim(get_the_content(), $settings['text_limit']), true); ?></p>
                                    </div>
                                </div>
                            </li>
                            <?php $i++;
							endwhile; ?>
                        </ul>
                        <?php }
						wp_reset_postdata(); ?>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12">
                        <div class="faq-two_form-box" <?php if($settings['bg_image']['id']) { ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>>
                            <h3 class="faq-two_form-title"><?php echo wp_kses( $settings['title'], true ); ?></h3>
                            
                            <?php if($settings['cf7_shortocde']){ ?>
                            <!-- Faq Form -->
                            <div class="faq-form">
                            	<?php echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]'); ?>
                            </div>
                            <!-- End Comment Form -->
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Faq Two -->
        
        <?php
    }
}
