<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Faqs_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_faqs_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Faqs V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'faqs', TR_URL . 'assets/js/faqs.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'faqs' ];
	}

    protected function _register_controls() {
        //Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Query
		$this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'conat' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 35,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of Post', 'conat' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 8,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'conat' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(

                    'date'       => esc_html__( 'Date', 'conat' ),
                    'title'      => esc_html__( 'Title', 'conat' ),
                    'menu_order' => esc_html__( 'Menu Order', 'conat' ),
                    'rand'       => esc_html__( 'Random', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'conat' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'conat' ),
                    'ASC'  => esc_html__( 'ASC', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'conat'),
                'options' => get_categories_list('faqs_cat')
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = conat_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'themerange-conat' );
        $args = array(
            'post_type'      => 'faqs',
            'posts_per_page' => conat_set( $settings, 'query_number' ),
            'orderby'        => conat_set( $settings, 'query_orderby' ),
            'order'          => conat_set( $settings, 'query_order' ),
            'paged'          => $paged
        );

        if( conat_set( $settings, 'query_category' ) ) $args['faqs_cat'] = conat_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) {
            $count = 1;
            $left_arr = array();
            $right_arr = array(); ?>

            <?php while ( $query->have_posts() ) : $query->the_post();

                if($count > 2) $count = 1;
                $active = ( $query->current_post == 0 ) ? 'active' : '';
                $current = ( $query->current_post == 0 ) ? 'current' : ''; ?>

                <?php if( ($count == 1)):
                    $left_arr[get_the_id()] = '<li class="accordion block active-block">
                                    <div class="acc-btn '.$active.'"><div class="icon-outer"><span class="icon fa-solid fa-angle-down fa-fw"></span></div>'.get_the_title(get_the_id()).'</div>
                                    <div class="acc-content '.$current.'">
                                        <div class="content">
                                            <p>'.conat_trim(get_the_content(), $settings['text_limit']).'</p>
                                        </div>
                                    </div>
                                </li>';
                    ?>
                <?php else:
                    $right_arr[get_the_id()] = '<li class="accordion block">
                                    <div class="acc-btn"><div class="icon-outer"><span class="icon fa-solid fa-angle-down fa-fw"></span></div>'.get_the_title(get_the_id()).'</div>
                                    <div class="acc-content">
                                        <div class="content">
                                            <p>'.conat_trim(get_the_content(), $settings['text_limit']).'</p>
                                        </div>
                                    </div>
                                </li>';
                    ?>
                <?php endif; ?>
                <?php $count++; endwhile; ?>
                
            <!-- Faq One -->
            <section class="faq-one" <?php if($settings['bg_image']['id']) { ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>>
                <div class="auto-container">
                    <div class="sec-title light centered">
                        <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                        <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                    </div>
                    <div class="row clearfix">
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <!-- Accordion Box -->
                            <ul class="accordion-box">
                            	<?php foreach($left_arr as $key => $left_content):
								echo wp_kses_post($left_content);
								endforeach; ?>
                            </ul>
                        </div>
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <!-- Accordion Box -->
                            <ul class="accordion-box">
                            	<?php foreach($right_arr as $key => $right_content) :
								echo wp_kses_post($right_content);
								endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
            <!-- End Faq One -->
            
        <?php }
        
		wp_reset_postdata();
    }
}
