<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

class Facts_Counter_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_facts_counter_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Facts Counter V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'odometer-counter', TR_URL . 'assets/js/odometer-counter.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'odometer-counter' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Facts Counter
		$this->start_controls_section(
            'facts_tab',
            [
                'label' => esc_html__( 'Facts Counter', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'number',
			[
				'label' => esc_html__('Number', 'conat'),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
			]
		);
		$repeater->add_control(
			'number_prefix',
			[
				'label' => esc_html__('Number Prefix', 'conat'),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'number_suffix',
			[
				'label' => esc_html__('Number Suffix', 'conat'),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'facts',
			[
				'label'       => __( 'Facts Counter', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }
	
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Counter One -->
        <section class="counter-one">
            <div class="auto-container">
                <div class="inner-container">
                    <?php if($settings['bg_image']['id']) { ?><div class="counter-one_image" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"></div><?php } ?>
                    <div class="row clearfix">
                    	<?php foreach($settings['facts'] as $key => $item) { ?>
                        <!-- Counter Column -->
                        <div class="counter-one_block col-lg-3 col-md-6 col-sm-12">
                            <div class="counter-one_inner">
                                <div class="counter-one_counter"><?php echo wp_kses( $item['number_prefix'], true ); ?><span class="odometer" data-count="<?php echo esc_attr($item['number']); ?>"></span><?php echo wp_kses( $item['number_suffix'], true ); ?></div>
                                <div class="counter-one_text"><?php echo wp_kses( $item['title'], true ); ?></div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Counter One -->
        
        <?php
    }
}
