<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Events_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_events_v2';
    }

    public function get_title() {
        return esc_html__( 'Conat Events V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'query',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'conat' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 6,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
		$this->add_control(
            'query_number',
            [
                'label' => esc_html__('Number of Post', 'conat'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4,
                'min' => 1,
                'max' => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label' => esc_html__('Order By', 'conat'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date' => esc_html__('Date', 'conat'),
                    'title' => esc_html__('Title', 'conat'),
                    'menu_order' => esc_html__('Menu Order', 'conat'),
                    'rand' => esc_html__('Random', 'conat'),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label' => esc_html__('Order', 'conat'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'ASC' => esc_html__( 'Ascending', 'conat' ),
                    'DESC' => esc_html__( 'Descending', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'conat'),
                'options' => get_categories_list('tribe_events_cat')
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_html = wp_kses_allowed_html('post');
		
		$paged = get_query_var('paged');
		$paged = conat_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute('wrapper', 'class', 'themerange-conat');
        $args = array(
            'post_type' => 'tribe_events',
            'posts_per_page' => conat_set($settings, 'query_number'),
            'orderby' => conat_set($settings, 'query_orderby'),
            'order' => conat_set($settings, 'query_order'),
            'paged' => $paged
        );

        if( conat_set($settings, 'query_category')) $args['tribe_events_cat'] = conat_set($settings, 'query_category');
        $query = new \WP_Query($args);
		
		if($query->have_posts()) { ?>
		<!-- Event Three -->
        <section class="event-three">
            <div class="auto-container">
				<?php $i=0;
				global $post;
				while($query->have_posts()) : $query->the_post();
				$start_datetime = tribe_get_start_date(get_the_id());
				$end_datetime = tribe_get_end_date(get_the_id());

				$start_date = tribe_get_start_date(get_the_id(), null, false, 'd' );
				$end_date = tribe_get_end_date(get_the_id(), null, false, 'd M, Y' );

				$start_time = tribe_get_start_time ( get_the_id(), 'h:i A' );
				$end_time = tribe_get_end_time ( get_the_id(), 'h:i A' );
				
				$location = get_option('location');
				$term_list = wp_get_post_terms($post->ID, 'tribe_events_cat', array("fields" => "names")); ?>
                <!-- Leadership One Ship -->
                <div class="leadership-one_block <?php if($i%2) echo 'style-two'; ?>">
                    <div class="leadership-one_block-inner">
                        <div class="leadership-one_block-content">
                            <?php $speaker_image = get_post_meta( get_the_id(), 'speaker_image', true );
                            if($speaker_image) { ?>
                            <div class="leadership-one_block-image">
                                <img src="<?php echo esc_url(wp_get_attachment_url($speaker_image['id'])); ?>" alt="<?php esc_attr_e('Speaker Image', 'conat'); ?>">
                                
                                <?php if( get_post_meta( get_the_id(), 'audio', true ) == 'sc_audio' ) {
									$sc_id = get_post_meta( get_the_id(), 'sc_id', true );
									$auto_play = get_post_meta( get_the_id(), 'auto_play', true );
								?>
								<a href="<?php echo esc_url('https://w.soundcloud.com/player/?visual=true&amp;url=https://api.soundcloud.com/tracks/'.esc_attr($sc_id).'&amp;show_artwork=true&amp;maxwidth=1020&amp;maxheight=1000&amp;auto_play='.esc_attr($auto_play).''); ?>" class="lightbox-audio mfp-iframe audio leadership-one_block-icon flaticon-voice"></a>
								<?php } else { ?>
								<div class="leadership-one_block-icon flaticon-voice"></div>
								<?php } ?>
                                
                            </div>
                            <?php } ?>
                            <div class="leadership-one_block-time"><?php echo wp_kses($start_time, true); ?> -- <?php echo wp_kses($end_time, true); ?></div>
                            <div class="leadership-one_block-name"><?php echo wp_kses(get_post_meta( get_the_id(), 'speaker_name', true ), true); ?></div>
                            <h3 class="leadership-one_block-title"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h3>
                            <div class="leadership-one_block-text"><?php echo wp_kses(get_post_meta( get_the_id(), 'short_description', true ), true); ?></div>
                        </div>
                    </div>
                </div>
                <?php $i++;
				endwhile; ?>
                
                <!-- Styled Pagination -->
                <?php conat_the_pagination2(array('total' =>$query->max_num_pages, 'next_text' => '<span class="fa fa-angle-double-right"></span>', 'prev_text' => '<span class="fa fa-angle-double-left"></span>')); ?>
                <!-- End Styled Pagination -->
                
            </div>
        </section>
        
        <?php }
		wp_reset_postdata();
    }
}
   