<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Events_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_events_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Events V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'event_tab',
            [
                'label' => esc_html__( 'Events', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'events',
			[
				'label'       => __( 'Events', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
		if ($settings['events']) { ?>
        
        <!-- Event One -->
        <section class="event-one">
            <div class="auto-container">
                <div class="row clearfix">
                	<?php foreach($settings['events'] as $key => $item): ?>
                    <!-- Event Block One -->
                    <div class="event-block_one col-lg-6 col-md-6 col-sm-12">
                        <div class="event-block_one-inner">
                            <div class="event-block_one-content">
                                <div class="event-block_one-icon <?php echo esc_attr($item['icon'], true); ?>"></div>
                                <strong><?php echo wp_kses($item['title'], true); ?></strong>
                                <?php echo wp_kses($item['text'], true); ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <!-- End Event One -->
        
        <?php }
    }
}
   