<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Event_Details extends Widget_Base {

    public function get_name() {
        return 'conat_event_details';
    }

    public function get_title() {
        return esc_html__( 'Conat Event Details', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );
        $this->add_control(
            'bottom_text',
            [
                'label' => __( 'BottomText', 'conat' ),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'conat' ),
            ]
        );
		$this->add_control(
            'title',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'features',
			[
				'label'       => __( 'Features', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ text }}}',
			]
		);
        $this->end_controls_section();
		
		//Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <?php echo wp_kses( $settings['text'], true ); ?>
        
        <div class="middle-column">
            <div class="row clearfix">
                <div class="column col-lg-6 col-md-12 col-sm-12">
                    <h3 class="event-detail_subtitle"><?php echo wp_kses( $settings['title'], true ); ?></h3>
                    
                    <?php if ($settings['features']){ ?>
                    <ul class="event-detail_list">
                    	<?php foreach($settings['features'] as $key => $item) { ?>
                        <li><?php echo wp_kses( $item['text'], true ); ?></li>
                        <?php } ?>
                    </ul>
                    <?php } ?>
                </div>
                <div class="column col-lg-6 col-md-6 col-sm-12">
                	<?php if($settings['image']['id']) { ?>
                    <div class="event-detail_image-two">
                        <img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        
        <?php echo wp_kses( $settings['bottom_text'], true ); ?>
        
        <?php
    }
}
