<?php namespace CONATPLUGIN\Element;

class Elementor {
	static $widgets = array(
		//Slider
		'about_us',
		'slider_v1',
		'slider_v2',
		'slider_v3',
		'slider_v4',
		
		//Banner
		'banner_v1',
		
		//Home 01
		'about_us_v1',
		'facts_counter_v1',
		'speaker_v1',
		'our_features',
		'thought_leadership_v1',
		'gallery_v1',
		'price_table_v1',
		'video',
		'partners',
		'news_v1',
		'subscriber',
		
		//Home 02
		'about_us_v2',
		'events_v1',
		'facts_counter_v2',
		'join_the_event_v1',
		'speaker_v2',
		'thought_leadership_v2',
		'faqs_v1',
		'price_table_v2',
		'news_v2',
		'contact_info',
		
		//Home 03
		'join_the_event_v2',
		'about_us_v3',
		'facts_counter_v3',
		'speaker_v3',
		'thought_leadership_v3',
		'testimonials_v1',
		'price_table_v3',
		'news_v3',
		'gallery_v2',
		
		//Home 04
		'about_us_v4',
		'our_features_v2',
		'thought_leadership_v4',
		'register_now',
		'price_table_v4',
		'speaker_v4',
		'call_to_action',
		
		//Home 05
		'countdown',
		'join_the_event_v3',
		'price_table_v5',
		
		//Inner Pages
		'faqs_v2',
		'gallery_v3',
		'testimonials_v2',
		'coming_soon',
		'terms_and_conditions',
		'privacy_policy',
		'speaker_details',
		'events_v2',
		'event_details',
		'blog_with_sidebar',
		'blog_details',
		'contact_us_v1',
		'google_map',
		'contact_us_v2',
		'google_map_contact_info',
		'contact_us_v3',
	);

	static function init() {
		add_action( 'elementor/init', array( __CLASS__, 'loader' ) );
		add_action( 'elementor/elements/categories_registered', array( __CLASS__, 'register_cats' ) );
	}

	static function loader() {

		foreach ( self::$widgets as $widget ) {

			$file = CONATPLUGIN_PLUGIN_PATH . '/elementor/' . $widget . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}

			add_action( 'elementor/widgets/widgets_registered', array( __CLASS__, 'register' ) );
		}
	}

	static function register( $elemntor ) {
		foreach ( self::$widgets as $widget ) {
			$class = '\\CONATPLUGIN\\Element\\' . ucwords( $widget );

			if ( class_exists( $class ) ) {
				$elemntor->register_widget_type( new $class );
			}
		}
	}

	static function register_cats( $elements_manager ) {

		$elements_manager->add_category(
			'conat',
			[
				'title' => esc_html__( 'Conat', 'conat' ),
				'icon' => 'fa fa-plug',
			]
		);
	}
}

Elementor::init();