<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Countdown extends Widget_Base {

    public function get_name() {
        return 'conat_countdown';
    }

    public function get_title() {
        return esc_html__( 'Conat Countdown', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'time-countdown', TR_URL . 'assets/js/time-countdown.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'time-countdown' ];
	}
	
    protected function _register_controls() {
		$this->start_controls_section(
            'countdown_tab',
            [
                'label' => esc_html__( 'Countdown', 'conat' ),
            ]
        );
		$this->add_control(
            'day',
            [
                'label' => __( 'Day', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'month',
            [
                'label' => __( 'Month', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'address',
            [
                'label' => __( 'Address', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'countdown',
            [
                'label' => __( 'Countdown', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'placeholder' => 'yyyy/mm/dd',
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Countdown Section -->
        <section class="countdown-section">
            <div class="auto-container">
                <div class="outer-box wow fadeInUp clearfix">
                    <div class="date-column">
                        <div class="date"><strong><?php echo wp_kses($settings['day'], true); ?></strong><?php echo wp_kses($settings['month'], true); ?></div>
                        <div class="location"><?php echo wp_kses($settings['address'], true); ?></div>
                    </div>
                    
                    <?php if ($settings['countdown']) { ?>
                    <div class="countdown-column">
                        <div class="time-counter"><div class="time-countdown clearfix" data-countdown="<?php echo wp_kses($settings['countdown'], true); ?>"></div></div>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </section>
        <!--End Countdown Section -->
        
		<?php
    }
}
