<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Contact_Us_V3 extends Widget_Base {

    public function get_name() {
        return 'conat_contact_us_v3';
    }

    public function get_title() {
        return esc_html__( 'Conat Contact Us V3', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true
            ]
        );
        $this->end_controls_section();
		
		//Contact Form
        $this->start_controls_section(
            'contact_tab',
            [
                'label' => esc_html__( 'Contact Form', 'conat' ),
            ]
        );
        $this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Form', 'conat'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
		
		//Image
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Contact Form Section -->
        <section class="contact-form-section">
            <div class="auto-container">
                <div class="row clearfix">
                    <!-- Form Column -->
                    <div class="form-column col-lg-7 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <h3><?php echo wp_kses( $settings['title'], true ); ?></h3>
                            
                            <?php if($settings['cf7_shortocde']){ ?>
                            <!-- Comment Form -->
                            <div class="default-form contact-form">
                                <div id="contact-form">
                                	<?php echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]'); ?>
                                </div>
                            </div>
                            <!-- End Comment Form -->
                            <?php } ?>
                        </div>
                    </div>
                    <!-- Image Column -->
                    <div class="image-column col-lg-5 col-md-12 col-sm-12">
                        <?php if($settings['image']['id']) { ?>
                        <div class="inner-column">
                            <div class="image wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Contact Form Section -->
        
        <?php
    }
}
