<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Contact_Us_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_contact_us_v2';
    }

    public function get_title() {
        return esc_html__( 'Conat Contact Us V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		//Address
        $this->start_controls_section(
            'address_tab',
            [
                'label' => esc_html__( 'Address', 'conat' ),
            ]
        );
		$this->add_control(
            'icon',
            [
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => get_fontawesome_icons(),
			]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'address',
            [
                'label' => __( 'Address', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Email Address
		$this->start_controls_section(
            'email_tab',
            [
                'label' => esc_html__( 'Email Address', 'conat' ),
            ]
        );
		$this->add_control(
            'icon2',
            [
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => get_fontawesome_icons(),
			]
        );
        $this->add_control(
            'title2',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'email_address1',
            [
                'label' => __( 'Email Address 1', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'email_address2',
            [
                'label' => __( 'Email Address 2', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Phone Number
		$this->start_controls_section(
            'phone_tab',
            [
                'label' => esc_html__( 'Phone Number', 'conat' ),
            ]
        );
		$this->add_control(
            'icon3',
            [
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => get_fontawesome_icons(),
			]
        );
        $this->add_control(
            'title3',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'phone_number1',
            [
                'label' => __( 'Phone Number 1', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'phone_number2',
            [
                'label' => __( 'Phone Number 2', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Social Media
        $this->start_controls_section(
            'social_tab',
            [
                'label' => esc_html__( 'Social Media', 'conat' ),
            ]
        );
		$this->add_control(
            'icon4',
            [
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => get_fontawesome_icons(),
			]
        );
        $this->add_control(
            'title4',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'social_link',
			[
				'label' => __( 'Social Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com/', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'social_media',
			[
				'label'       => __( 'Social Media', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
		
		//Contact Form
        $this->start_controls_section(
            'contact_tab',
            [
                'label' => esc_html__( 'Contact Form', 'conat' ),
            ]
        );
		$this->add_control(
            'subtitle5',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'title5',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Form', 'conat'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
		
		//Google Map
		$this->start_controls_section(
			'google_map',
			[
				'label' => esc_html__( 'Google Map', 'conat' ),
			]
		);
		$this->add_control(
			'google_map_iframe',
			[
				'label' => __( 'Google Map Iframe', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic'  => [
					'active' => true,
				],
			]
		);
		$this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Contact Page Section -->
        <section class="contact-page-section">
            <div class="auto-container">
                <div class="row clearfix">
                    <!-- Info Column -->
                    <div class="info-column col-lg-3 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <?php if ($settings['icon'] OR $settings['title'] OR $settings['address']){ ?>
                            <!-- Info Box -->
                            <div class="info-box">
                                <div class="box-inner">
                                    <span class="icon <?php echo esc_attr( $settings['icon'], true ); ?>"></span>
                                    <h6><?php echo wp_kses( $settings['title'], true ); ?></h6>
                                    <div class="text"><?php echo wp_kses( $settings['address'], true ); ?></div>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <?php if ($settings['icon2'] OR $settings['title2'] OR $settings['email_address1'] OR $settings['email_address2']){ ?>
                            <!-- Info Box -->
                            <div class="info-box">
                                <div class="box-inner">
                                    <span class="icon <?php echo esc_attr( $settings['icon2'], true ); ?>"></span>
                                    <h6><?php echo wp_kses( $settings['title2'], true ); ?></h6>
                                    <a href="mailto:<?php echo sanitize_email($settings['email_address1']); ?>"><?php echo sanitize_email($settings['email_address1']); ?></a><br>
                                    <a href="mailto:<?php echo sanitize_email($settings['email_address2']); ?>"><?php echo sanitize_email($settings['email_address2']); ?></a>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <?php if ($settings['icon3'] OR $settings['title3'] OR $settings['phone_number1'] OR $settings['phone_number2']){ ?>
                            <!-- Info Box -->
                            <div class="info-box">
                                <div class="box-inner">
                                    <span class="icon <?php echo esc_attr( $settings['icon3'], true ); ?>"></span>
                                    <h6><?php echo wp_kses( $settings['title3'], true ); ?></h6>
                                    <a href="tel:<?php echo esc_attr(conat_phone_number($settings['phone_number1'])); ?>"><?php echo wp_kses( $settings['phone_number1'], true ); ?></a><br>
                                    <a href="tel:<?php echo esc_attr(conat_phone_number($settings['phone_number2'])); ?>"><?php echo wp_kses( $settings['phone_number2'], true ); ?></a>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <?php if ($settings['icon4'] OR $settings['title4'] OR $settings['social_media']){ ?>
                            <!-- Info Box -->
                            <div class="info-box">
                                <div class="box-inner">
                                    <span class="icon <?php echo esc_attr( $settings['icon4'], true ); ?>"></span>
                                    <h6><?php echo wp_kses( $settings['title4'], true ); ?></h6>
                                    <?php if($settings['social_media']){ ?>
                                    <ul class="social-box">
                                        <?php foreach($settings['social_media'] as $key => $item) { ?>
                                        <li><a href="<?php echo esc_url( $item['social_link']['url'] ); ?>" class="fa-brands fa-fw <?php echo esc_attr($item['icon']); ?>" target="_blank" rel="noopener"></a></li>
                                        <?php } ?>
                                    </ul>
                                    <?php } ?>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                    <!-- Form Column -->
                    <div class="form-column col-lg-9 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <!-- Sec Title -->
                            <div class="sec-title">
                                <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle5'], true ); ?></div>
                                <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title5'], true ); ?></h2>
                            </div>
                            
                            <?php if($settings['cf7_shortocde']){ ?>
                            <!-- Contact Form -->
                            <div class="default-form contact-form">
                                <div id="contact-form">
									<?php echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]'); ?>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <!-- Map Boxed -->
                            <div class="map-boxed">
                                <div class="map-outer">
                                    <?php echo do_shortcode($settings['google_map_iframe']); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Contact Page Section -->
        
        <?php
    }
}
