<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Contact_Info extends Widget_Base {

    public function get_name() {
        return 'conat_contact_info';
    }

    public function get_title() {
        return esc_html__( 'Conat Contact Info', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Google Map
		$this->start_controls_section(
            'map_tab',
            [
                'label' => esc_html__( 'Google Map', 'conat' ),
            ]
        );
        $this->add_control(
            'google_map',
            [
                'label' => __( 'Google Map', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Contact Info
        $this->start_controls_section(
            'contact_info_tab',
            [
                'label' => esc_html__( 'Contact Info', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'contact_info',
			[
				'label'       => __( 'Contact Info', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Location One -->
        <section class="location-one" <?php if($settings['bg_image']['id']) { ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>>
            <div class="auto-container">
                <div class="sec-title title-anim centered">
                    <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                <div class="row clearfix">
                    <!-- Map Column -->
                    <div class="location-one_map-column col-lg-8 col-md-12 col-sm-12">
                        <?php echo do_shortcode($settings['google_map']); ?>
                    </div>
                    
                    <?php if ($settings['contact_info']){ ?>
                    <!-- Info Column -->
                    <div class="location-one_info-column col-lg-4 col-md-12 col-sm-12">
                    	<?php foreach($settings['contact_info'] as $key => $item) { ?>
                        <!-- Location Info Block -->
                        <div class="location-info_block">
                            <div class="location-info_block-inner">
                                <div class="location-info_block-content">
                                    <div class="location-info_block-icon <?php echo esc_attr($item['icon']); ?>"></div>
                                    <strong><?php echo wp_kses( $item['title'], true ); ?></strong>
                                    <?php echo wp_kses( $item['text'], true ); ?>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </section>
        <!-- End Location One -->
        
        <?php
    }
}
