<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Coming_Soon extends Widget_Base {

    public function get_name() {
        return 'conat_coming_soon';
    }

    public function get_title() {
        return esc_html__( 'Conat Coming Soon', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'clock-countdown', TR_URL . 'assets/js/countdown.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'clock-countdown' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'logo',
            [
                'label' => __( 'Logo', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Date
		$this->start_controls_section(
            'date_tab',
            [
                'label' => esc_html__( 'Date', 'conat' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'date',
            [
                'label' => __( 'Date', 'conat' ),
                'type' => Controls_Manager::DATE_TIME,
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'title1',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'text1',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Subscriber
        $this->start_controls_section(
            'subscriber_tab',
            [
                'label' => esc_html__( 'Select Form', 'conat' ),
            ]
        );
        $this->add_control(
            'cf7_shortocde',
            [
                'label' => esc_html__('Select Form', 'conat'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => get_contact_form_7_list(),
            ]
        );
        $this->end_controls_section();
		
		//Social Media
        $this->start_controls_section(
            'social_tab',
            [
                'label' => esc_html__( 'Social Media', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'social_link',
			[
				'label' => __( 'Social Link', 'conat' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com/', 'conat' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
		$this->add_control(
			'social_media',
			[
				'label'       => __( 'Social Media', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <style id="clock-animations"></style>
        
        <!-- Coming Soon -->
        <section class="coming-soon" <?php if($settings['bg_image']['id']) { ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)"<?php } ?>>
            <div class="content">
                <div class="content-inner">
                    <div class="auto-container">
                    	<?php if($settings['logo']['id']) { ?><div class="logo"><img src="<?php echo esc_url(wp_get_attachment_url($settings['logo']['id'])); ?>" alt="<?php esc_attr_e('Logo', 'conat'); ?>" /></div><?php } ?>
                        <div class="sec-title centered"><h2><?php echo wp_kses( $settings['title'], true ); ?></h2></div>
                        <div class="time-counter">
                            <!-- Time Countdown -->
                            <div class="time-countdown clearfix" data-countdown="<?php echo esc_attr(date("Y/m/d", strtotime($settings['date']))); ?>"></div>
    
                            <!-- Clock / Bg Clock -->
                            <div class="clock-wrapper">
                                <div class="clock-base">
                                    <div class="click-indicator">
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                        <div><span></span></div>
                                    </div>
                                    <div class="clock-hour"></div>
                                    <div class="clock-minute"></div>
                                    <div class="clock-second"></div>
                                    <div class="clock-center"></div>
                                </div>
                            </div>
                        </div>
                        <!--Emailed Form-->
                        <div class="emailed-form">
                            <h3><?php echo wp_kses( $settings['title1'], true ); ?></h3>
                            <div class="text"><?php echo wp_kses( $settings['text1'], true ); ?></div>
                            <?php if ($settings['cf7_shortocde']) {
								echo do_shortcode('[contact-form-7 id="'.esc_attr($settings['cf7_shortocde']).'"]');
							} ?>
                        </div>
                        
                        <?php if($settings['social_media']){ ?>
                        <ul class="social-box">
                            <?php foreach($settings['social_media'] as $key => $item) { ?>
                            <li><a href="<?php echo esc_url( $item['social_link']['url'] ); ?>" class="fa-brands fa-fw <?php echo esc_attr($item['icon']); ?>" target="_blank" rel="noopener"></a></li>
                            <?php } ?>
                        </ul>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Coming Soon -->
        
        <?php
    }
}
