<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Blog_With_Sidebar extends Widget_Base {

    public function get_name() {
        return 'conat_blog_with_sidebar';
    }

    public function get_title() {
        return esc_html__('Conat Blog With Sidebar', 'conat');
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'query_tab',
            [
                'label' => esc_html__( 'Query', 'conat' ),
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label' => esc_html__('Number of Post', 'conat'),
                'type' => Controls_Manager::NUMBER,
                'default' => 8,
                'min' => 1,
                'max' => 100,
                'step' => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label' => esc_html__('Order By', 'conat'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date' => esc_html__('Date', 'conat'),
                    'title' => esc_html__('Title', 'conat'),
                    'menu_order' => esc_html__('Menu Order', 'conat'),
                    'rand' => esc_html__('Random', 'conat'),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label' => esc_html__('Order', 'conat'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'ASC' => esc_html__( 'Ascending', 'conat' ),
                    'DESC' => esc_html__( 'Descending', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'label' => esc_html__('Category', 'conat'),
                'type' => Controls_Manager::SELECT,
                'options' => get_categories_list(),
            ]
        );
        $this->end_controls_section();
		
		//Sidebar
		$this->start_controls_section(
            'sidebar_tab',
            [
                'label' => esc_html__('Sidebar', 'conat'),
            ]
        );
		$this->add_control(
            'left_right_sidebar',
            [
                'label' => esc_html__('Sidebar', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'right',
                'options' => array(
                    'left' => esc_html__('Left Sidebar', 'conat'),
                    'right' => esc_html__('Right Sidebar', 'conat'),
                ),
            ]
        );
		$this->add_control(
			'sidebar',
			[
				'label' => esc_html__('Choose Sidebar', 'conat'),
				'separate' => 'before',
				'type' => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options' => conat_get_sidebars(),
			]
		);
        $this->end_controls_section();
		
		
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_html = wp_kses_allowed_html('post');
		
		$paged = get_query_var('paged');
		$paged = conat_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute('wrapper', 'class', 'themerange-conat');
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => conat_set($settings, 'query_number'),
            'orderby' => conat_set($settings, 'query_orderby'),
            'order' => conat_set($settings, 'query_order'),
            'paged' => $paged
        );

        if( conat_set($settings, 'query_category')) $args['category_name'] = conat_set($settings, 'query_category');
        $query = new \WP_Query($args); ?>
        
		<!-- Sidebar Page Container -->
        <div class="sidebar-page-container">
            <div class="auto-container">
                <div class="row clearfix">
                    <?php if($settings['left_right_sidebar'] == 'left') { ?>
                    <!-- Sidebar Side -->
                    <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                        <aside class="sidebar sticky-top">
                        	<?php dynamic_sidebar($settings['sidebar'] ); ?>
                        </aside>
                    </div>
                    <?php } ?>
                    
                    <?php if($query->have_posts()) { ?>
                    <!-- Content Side -->
                    <div class="content-side col-lg-8 col-md-12 col-sm-12">
                        <div class="our-blog">
                            <div class="row clearfix">
                            	<?php while($query->have_posts()) : $query->the_post(); ?>
                                <!-- News Block -->
                                <div class="news-block_one col-lg-6 col-md-6 col-sm-12">
                                    <div class="news-block_one-inner">
                                        <?php if (has_post_thumbnail()){ ?>
                                        <!-- Post Info -->
                                        <div class="news-block_one-image">
                                            <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_post_thumbnail('conat_370x500'); ?></a>
                                            <?php the_post_thumbnail('conat_370x500'); ?>
                                        </div>
                                        <?php } ?>
                                        
                                        <div class="news-block_one-content">
                                            <div class="news-block_one-date"><?php echo get_the_date(); ?></div>
                                            <ul class="news-block_one-meta">
                                                <li><span class="icon fa-regular fa-calendar fa-fw"></span><?php esc_html_e('by', 'conat'); ?> <?php the_author(); ?></li>
                                                <li><span class="icon fa-solid fa-comments fa-fw"></span><?php comments_number( '(0) Comments', '(1) Comment', '(%) Comments' ); ?></li>
                                            </ul>
                                            <h5 class="news-block_two-title"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h5>
                                            <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>" class="news-block_two-more"><?php esc_html_e('Read more', 'conat'); ?></a>
                                        </div>
                                    </div>
                                </div>
                                <?php endwhile; ?>
                                
                                <!-- Styled Pagination -->
                                <?php conat_the_pagination2(array('total' =>$query->max_num_pages, 'next_text' => '<span class="fa fa-angle-double-right"></span>', 'prev_text' => '<span class="fa fa-angle-double-left"></span>')); ?>
                                <!-- End Styled Pagination -->
                            </div>
                        </div>
                    </div>
                    <?php }
					wp_reset_postdata(); ?>
                    
                    <?php if($settings['left_right_sidebar'] == 'right') { ?>
                    <!-- Sidebar Side -->
                    <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                        <aside class="sidebar sticky-top">
                        	<?php dynamic_sidebar($settings['sidebar'] ); ?>
                        </aside>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        
        <?php
    }
}
