<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Blog_Details extends Widget_Base {

    public function get_name() {
        return 'conat_blog_details';
    }

    public function get_title() {
        return esc_html__( 'Conat Blog Details', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
        //Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );
        $this->end_controls_section();
		
		//Quote
        $this->start_controls_section(
            'quote_tab',
            [
                'label' => esc_html__( 'Quote', 'conat' ),
            ]
        );
		$this->add_control(
            'quote',
            [
                'label' => __( 'Quote', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$this->add_control(
            'author',
            [
                'label' => __( 'Author', 'conat' ),
				'type' => Controls_Manager::TEXT,
            ]
        );
        $this->end_controls_section();
		
		//Image
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'text2',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::WYSIWYG,
            ]
        );
		$this->add_control(
            'bottom_text',
            [
                'label' => __( 'Bottom Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <?php echo wp_kses( $settings['text'], true ); ?>
        
        <?php if ($settings['quote']){ ?>
        <blockquote>
            <?php echo wp_kses( $settings['quote'], true ); ?>
            <span class="blockquote_author"><?php echo wp_kses( $settings['author'], true ); ?></span>
            <span class="blockquote_quote flaticon-quote"></span>
        </blockquote>
        <?php } ?>
        
        <div class="two-column">
            <div class="row clearfix">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <?php if($settings['image']['id']) { ?>
                    <div class="news-block_one-image-two">
                        <img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                    </div>
                    <?php } ?>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <?php echo wp_kses( $settings['text2'], true ); ?>
                </div>
            </div>
        </div>
        <p><?php echo wp_kses( $settings['bottom_text'], true ); ?></p>
        
        <?php
    }
}
