<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class Banner_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_banner_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat Banner', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'time-countdown', TR_URL . 'assets/js/time-countdown.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'time-countdown' ];
	}
	
    protected function _register_controls() {
		//Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'background_image',
            [
                'label' => __( 'Background Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$this->add_control(
            'address',
            [
                'label' => __( 'Address', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'date',
            [
                'label' => __( 'Date', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'countdown',
            [
                'label' => __( 'Countdown', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'placeholder' => 'yyyy/mm/dd',
            ]
        );
        $this->end_controls_section();
		
		//Button
		$this->start_controls_section(
            'button_tab',
            [
                'label' => esc_html__( 'Button', 'conat' ),
            ]
        );
		$this->add_control(
            'btn_style1',
            [
                'label' => esc_html__('Style 1', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'one',
                'options' => conat_button_style(),
            ]
        );
        $this->add_control(
            'btn_name1',
            [
                'label' => __( 'Name 1', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_link1',
            [
                'label' => __( 'Link 1', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
		$this->add_control(
            'btn_style2',
            [
                'label' => esc_html__('Style 2', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'one',
                'options' => conat_button_style(),
            ]
        );
        $this->add_control(
            'btn_name2',
            [
                'label' => __( 'Name 2', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_link2',
            [
                'label' => __( 'Link 2', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Events Banner Section -->
        <section class="events-banner-section" <?php if($settings['background_image']['id']) { ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['background_image']['id'])); ?>)"<?php } ?>>
            <!-- Icons -->
            <div class="icons parallax-scene-1">
                <!-- Icon One -->
                <div data-depth="0.20" class="icon-one parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-14.png'); ?>)"></div>
                <!-- Icon Two -->
                <div data-depth="0.50" class="icon-two parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-15.png'); ?>)"></div>
                <!-- Icon Three -->
                <div data-depth="0.10" class="icon-three parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-16.png'); ?>)"></div>
                <!-- Icon Four -->
                <div data-depth="0.30" class="icon-four parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-17.png'); ?>)"></div>
                <!-- Icon Five -->
                <div data-depth="0.10" class="icon-five parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-18.png'); ?>)"></div>
                <!-- Icon Six -->
                <div data-depth="0.20" class="icon-six parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-19.png'); ?>)"></div>
                <!-- Icon Seven -->
                <div data-depth="0.10" class="icon-seven parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-20.png'); ?>)"></div>
                <!-- Icon One -->
                <div data-depth="0.20" class="icon-eight parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-21.png'); ?>)"></div>
                <!-- Icon Two -->
                <div data-depth="0.50" class="icon-nine parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-14.png'); ?>)"></div>
                <!-- Icon Three -->
                <div data-depth="0.10" class="icon-ten parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-18.png'); ?>)"></div>
                <!-- Icon Four -->
                <div data-depth="0.30" class="icon-eleven parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-20.png'); ?>)"></div>
                <!-- Icon Five -->
                <div data-depth="0.10" class="icon-twelve parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-21.png'); ?>)"></div>
                <!-- Icon Six -->
                <div data-depth="0.20" class="icon-thirteen parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-15.png'); ?>)"></div>
                <!-- Icon Seven -->
                <div data-depth="0.10" class="icon-fourteen parallax-layer" style="background-image:url(<?php echo esc_url(get_template_directory_uri().'/assets/images/icons/icon-16.png'); ?>)"></div>
            </div>
            <div class="auto-container">
                <!-- Content Boxed -->
                <div class="content-boxed">
                    <div class="inner-column">
                        <h1><?php echo wp_kses($settings['title'], true); ?></h1>
                        
                        <?php if ($settings['address'] or $settings['date']) { ?>
                        <ul class="event-info">
                            <?php if ($settings['address']) { ?><li><span class="icon fa-solid fa-location-pin fa-fw"></span><?php echo wp_kses($settings['address'], true); ?></li><?php } ?>
                            <?php if ($settings['date']) { ?><li><span class="icon fa-solid fa-clock fa-fw"></span><?php echo wp_kses($settings['date'], true); ?></li><?php } ?>
                        </ul>
                        <?php } ?>
                        
                        <?php if ($settings['countdown']) { ?>
                        <!-- Time Countdown -->
                        <div class="time-counter">
                            <div class="time-countdown clearfix" data-countdown="<?php echo wp_kses($settings['countdown'], true); ?>"></div>
                        </div>
                        <?php } ?>
                        
                        <div class="btns-box">
                            <?php if($settings['btn_link1']['url'] and $settings['btn_name1']) {
								echo conat_button($settings['btn_style1'], $settings['btn_name1'], $settings['btn_link1']['url']);
							} ?>
							<?php if($settings['btn_link2']['url'] and $settings['btn_name2']) {
								echo conat_button($settings['btn_style2'], $settings['btn_name2'], $settings['btn_link2']['url']);
							} ?>
                        </div>
                    </div>
                </div>
                
            </div>
            <!--Waves Container-->
            <div>
              <svg class="waves" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
              viewBox="0 24 150 28" preserveAspectRatio="none" shape-rendering="auto">
              <defs>
              <path id="gentle-wave" d="M-160 44c30 0 58-18 88-18s 58 18 88 18 58-18 88-18 58 18 88 18 v44h-352z" />
              </defs>
              <g class="parallax">
              <use xlink:href="#gentle-wave" x="48" y="0" fill="rgba(255,255,255,0.7" />
              <use xlink:href="#gentle-wave" x="48" y="3" fill="rgba(255,255,255,0.5)" />
              <use xlink:href="#gentle-wave" x="48" y="5" fill="rgba(255,255,255,0.3)" />
              <use xlink:href="#gentle-wave" x="48" y="7" fill="#fff" />
              </g>
              </svg>
            </div>
            <!--Waves end-->
        </section>
        <!--End Banner Section-->
        
		<?php
    }
}
