<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class About_Us_V4 extends Widget_Base {

    public function get_name() {
        return 'conat_about_us_v4';
    }

    public function get_title() {
        return esc_html__( 'Conat About Us V4', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		//Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'pattern_image',
            [
                'label' => __( 'Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'features',
			[
				'label'       => __( 'Features', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
		
		//Button
		$this->start_controls_section(
            'button_tab',
            [
                'label' => esc_html__( 'Button', 'conat' ),
            ]
        );
		$this->add_control(
            'btn_style',
            [
                'label' => esc_html__('Style', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'two',
                'options' => conat_button_style(),
            ]
        );
        $this->add_control(
            'btn_name',
            [
                'label' => __( 'Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Events About Section -->
        <section class="events-about-section">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!-- Image Column -->
                    <div class="image-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column titlt" data-tilt data-tilt-max="4">
                            <?php if($settings['pattern_image']['id']) { ?><div class="icon-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image']['id'])); ?>)"></div><?php } ?>
                            <div class="image">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content Column -->
                    <div class="content-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <div class="sec-title title-anim">
                                <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                                <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                <div class="sec-title_text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                            </div>
                            <div class="row clearfix">
                            	<?php if ($settings['features']) {
								foreach($settings['features'] as $key => $item) { ?>
                                <!-- About Event Block -->
                                <div class="about-event-block col-lg-6 col-md-6 col-sm-12">
                                    <div class="block-inner">
                                        <span class="icon-box <?php echo esc_attr( $item['icon'], true ); ?>"></span>
                                        <h5><?php echo wp_kses( $item['title'], true ); ?></h5>
                                        <div class="about-text"><?php echo wp_kses( $item['text'], true ); ?></div>
                                    </div>
                                </div>
                                <?php }
								} ?>
                            </div>
                            
                            <?php if($settings['btn_link']['url'] and $settings['btn_name']) { ?>
                            <!-- Btn Box -->
                            <div class="btn-box">
                                <?php echo conat_button($settings['btn_style'], $settings['btn_name'], $settings['btn_link']['url']); ?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!-- End Events About Section -->
        
        <?php
    }
}
