<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class About_Us_V3 extends Widget_Base {

    public function get_name() {
        return 'conat_about_us_v3';
    }

    public function get_title() {
        return esc_html__( 'Conat About Us V3', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }
    public function get_categories() {
        return [ 'conat' ];
    }

    protected function _register_controls() {
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
		$this->add_control(
            'bold_text',
            [
                'label' => __( 'Bold Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'features',
			[
				'label'       => __( 'Features', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
		
		//Button
		$this->start_controls_section(
            'button_tab',
            [
                'label' => esc_html__( 'Button', 'conat' ),
            ]
        );
		$this->add_control(
            'btn_style',
            [
                'label' => esc_html__('Style', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'one',
                'options' => conat_button_style(),
            ]
        );
        $this->add_control(
            'btn_name',
            [
                'label' => __( 'Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        $this->end_controls_section();
		
		//Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'pattern_image',
            [
                'label' => __( 'Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'image_1',
            [
                'label' => __( 'Image Top', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'image_2',
            [
                'label' => __( 'Image Bottom', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Image Text
		$this->start_controls_section(
            'image_text_tab',
            [
                'label' => esc_html__( 'Image Text', 'conat' ),
            ]
        );
		$this->add_control(
            'show_hide',
            [
                'label' => esc_html__( 'Show/Hide', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'show',
                'options' => array(
                    'show' => esc_html__( 'Show', 'conat' ),
                    'hide' => esc_html__( 'Hide', 'conat' ),
                ),
            ]
        );
		$this->add_control(
            'number',
            [
                'label' => __( 'Number', 'conat' ),
                'type' => Controls_Manager::NUMBER,
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
		$this->add_control(
            'number_suffix',
            [
                'label' => __( 'Number Suffix', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
		$this->add_control(
            'image_text1',
            [
                'label' => __( 'Text 1', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
		$this->add_control(
            'image_text2',
            [
                'label' => __( 'Text 2', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Business One -->
        <section class="business-one">
            <div class="auto-container">
                <div class="row clearfix">
                    <!-- Content Column -->
                    <div class="business-one_content-column col-lg-6 col-md-12 col-sm-12">
                        <div class="business-one_content-inner">
                            <div class="sec-title title-anim">
                                <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                                <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                            </div>
                            <div class="business-one_bold-text"><?php echo wp_kses( $settings['bold_text'], true ); ?></div>
                            <div class="business-one_text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                            
                            <?php if ($settings['features']) {
							foreach($settings['features'] as $key => $item) { ?>
                            <div class="business-one_feature">
                                <div class="business-one_feature-icon <?php echo esc_attr( $item['icon'], true ); ?>"></div>
                                <strong><?php echo wp_kses( $item['title'], true ); ?></strong>
                                <?php echo wp_kses( $item['text'], true ); ?>
                            </div>
                            <?php }
							} ?>
                            
                            <?php if($settings['btn_link']['url'] and $settings['btn_name']) { ?>
                            <div class="business-one_button">
                                <?php echo conat_button($settings['btn_style'], $settings['btn_name'], $settings['btn_link']['url']); ?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
    
                    <!-- Image Column -->
                    <div class="business-one_image-column col-lg-6 col-md-12 col-sm-12">
                        <div class="business-one_image-inner">
                            <?php if($settings['pattern_image']['id']) { ?><div class="business-one_pattern-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image']['id'])); ?>)"></div><?php } ?>
                            
                            <?php if ($settings['show_hide'] == 'show'){ ?>
                            <div class="business-one_experiance">
                            	<?php if ($settings['number'] AND $settings['number_suffix']){ ?>
                                <div class="business-one_counter"><span class="odometer" data-count="<?php echo esc_attr($settings['number']); ?>"></span><?php echo wp_kses( $settings['number_suffix'], true ); ?></div>
                                <?php } ?>
                                <i><?php echo wp_kses( $settings['image_text1'], true ); ?></i>
                                <strong><?php echo wp_kses( $settings['image_text2'], true ); ?></strong>
                            </div>
                            <?php } ?>
                            
                            <?php if($settings['image_1']['id']) { ?>
                            <div class="business-one_image">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['image_1']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                            </div>
                            <?php } ?>
                            
                            <?php if($settings['image_2']['id']) { ?>
                            <div class="business-one_image-two" data-parallax='{"y" : 80}'>
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['image_2']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Business One -->
        
        <?php
    }
}
