<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

class About_Us_V2 extends Widget_Base {

    public function get_name() {
        return 'conat_about_us_v2';
    }

    public function get_title() {
        return esc_html__( 'Conat About Us V2', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	public function get_script_depends() {
		wp_register_script( 'odometer-counter', TR_URL . 'assets/js/odometer-counter.js', [ 'elementor-frontend' ], TR_VERSION, true );
		return [ 'odometer-counter' ];
	}

    protected function _register_controls() {
		//Images
		$this->start_controls_section(
            'pattern_image_tab',
            [
                'label' => esc_html__( 'Pattern Images', 'conat' ),
            ]
        );
        $this->add_control(
            'pattern_image1',
            [
                'label' => __( 'Pattern Left Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'pattern_image2',
            [
                'label' => __( 'Pattern Right Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'pattern_image3',
            [
                'label' => __( 'Pattern Right Bottom Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$this->add_control(
            'author',
            [
                'label' => __( 'Author', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'location',
            [
                'label' => __( 'Location', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
		$this->add_control(
            'designation',
            [
                'label' => __( 'Designation', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'features',
			[
				'label'       => __( 'Features', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ text }}}',
			]
		);
        $this->end_controls_section();
		
		//Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Image Text
		$this->start_controls_section(
            'image_text_tab',
            [
                'label' => esc_html__( 'Image Text', 'conat' ),
            ]
        );
		$this->add_control(
            'show_hide',
            [
                'label' => esc_html__( 'Show/Hide', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'show',
                'options' => array(
                    'show' => esc_html__( 'Show', 'conat' ),
                    'hide' => esc_html__( 'Hide', 'conat' ),
                ),
            ]
        );
        $this->add_control(
            'pattern_image',
            [
                'label' => __( 'Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
		$this->add_control(
            'number',
            [
                'label' => __( 'Number', 'conat' ),
                'type' => Controls_Manager::NUMBER,
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
		$this->add_control(
            'number_suffix',
            [
                'label' => __( 'Number Suffix', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
		$this->add_control(
            'image_text1',
            [
                'label' => __( 'Text 1', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
		$this->add_control(
            'image_text2',
            [
                'label' => __( 'Text 2', 'conat' ),
                'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
                    'show_hide' => 'show'
                ]
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- About Two -->
        <section class="about-two">
            <?php if($settings['pattern_image1']['id']) { ?><div class="about-two_pattern-one" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image1']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['pattern_image2']['id']) { ?><div class="about-two_pattern-two" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image2']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['pattern_image3']['id']) { ?><div class="about-two_pattern-three" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image3']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="row clearfix">
                    <!-- Content Column -->
                    <div class="about-two_content-column col-lg-6 col-md-12 col-sm-12">
                        <div class="about-two_content-inner">
                            <div class="sec-title title-anim">
                                <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                                <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                                <div class="sec-title_text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                            </div>
                            
                            <?php if ($settings['features']) { ?>
                            <div class="about-two_options">
                                <ul class="about-two_options-list">
                                	<?php foreach($settings['features'] as $key => $item) { ?>
                                    <li><span class="icon <?php echo esc_attr($item['icon']); ?>"></span><?php echo wp_kses( $item['text'], true ); ?></li>
                                    <?php } ?>
                                </ul>
                            </div>
                            <?php } ?>
                            
                            <div class="d-flex align-items-center flex-wrap">
                                <div class="about-two_signature"><?php echo wp_kses($settings['author'], true); ?></div>
                                <div class="about-two_author">
                                    <?php echo wp_kses($settings['location'], true); ?> <span> <?php echo wp_kses($settings['designation'], true); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Image Column -->
                    <div class="about-two_image-column col-lg-6 col-md-12 col-sm-12">
                        <div class="about-two_image-inner">
                            <?php if($settings['image']['id']) { ?>
                            <div class="about-two_image titlt" data-tilt data-tilt-max="5">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                            </div>
                            <?php } ?>
                            
                            <?php if ($settings['show_hide'] == 'show'){ ?>
                            <!-- About Two Counter -->
                            <div class="about-two_counter" <?php if($settings['pattern_image']['id']) { ?>style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image']['id'])); ?>)"<?php } ?>>
                                
                                <?php if ($settings['number'] AND $settings['number_suffix']){ ?>
                                <div class="about-two_counter-words"><span class="odometer" data-count="<?php echo esc_attr($settings['number']); ?>"></span><?php echo wp_kses( $settings['number_suffix'], true ); ?></div>
                                <?php } ?>
                                <div class="about-two_counter-text"><?php echo wp_kses( $settings['image_text1'], true ); ?><span><?php echo wp_kses( $settings['image_text2'], true ); ?></span></div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End About Two -->
        
        <?php
    }
}
