<?php namespace CONATPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Plugin;

class About_Us_V1 extends Widget_Base {

    public function get_name() {
        return 'conat_about_us_v1';
    }

    public function get_title() {
        return esc_html__( 'Conat About Us V1', 'conat' );
    }

    public function get_icon() {
        return 'tr-custom-icon';
    }

    public function get_categories() {
        return [ 'conat' ];
    }
	
	//Shortcode
	protected function _register_controls() {
        $this->start_controls_section(
            'settings_tab',
            [
                'label' => esc_html__( 'Settings', 'conat' ),
            ]
        );
		$this->add_control(
            'style',
            [
                'label' => esc_html__( 'Top Extra Space', 'conat' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => array(
                    'no' => esc_html__( 'No', 'conat' ),
                    'yes' => esc_html__( 'Yes', 'conat' ),
                ),
            ]
        );
		$this->end_controls_section();
		
		//Images
		$this->start_controls_section(
            'image_tab',
            [
                'label' => esc_html__( 'Images', 'conat' ),
            ]
        );
        $this->add_control(
            'left_pattern_image',
            [
                'label' => __( 'Left Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_pattern_image',
            [
                'label' => __( 'Right Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'right_top_pattern',
            [
                'label' => __( 'Right Top Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'pattern_image',
            [
                'label' => __( 'Pattern Image', 'conat' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->end_controls_section();
		
		//Video
		$this->start_controls_section(
            'video_tab',
            [
                'label' => esc_html__( 'Video', 'conat' ),
            ]
        );
        $this->add_control(
            'video_url',
            [
                'label' => __( 'Video URL', 'conat' ),
                'type' => Controls_Manager::URL,
				'label_block' => true,
            ]
        );
        $this->end_controls_section();
		
		//Content
		$this->start_controls_section(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'conat' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => __( 'Sub Title', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$this->add_control(
            'bold_text',
            [
                'label' => __( 'Bold Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
		$this->add_control(
            'text',
            [
                'label' => __( 'Text', 'conat' ),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );
        $this->end_controls_section();
		
		//Features
		$this->start_controls_section(
            'features_tab',
            [
                'label' => esc_html__( 'Features', 'conat' ),
            ]
        );
		$repeater = new Repeater();
		$repeater->add_control(
			'title',
			[
				'label' => __( 'Title', 'conat' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Select Icon', 'conat'),
				'type' => Controls_Manager::SELECT2,
				'options' => get_fontawesome_icons(),
			]
		);
		$repeater->add_control(
			'text',
			[
				'label' => __( 'Text', 'conat' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);
		$this->add_control(
			'features',
			[
				'label'       => __( 'Features', 'conat' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->end_controls_section();
		
		//Button
		$this->start_controls_section(
            'button_tab',
            [
                'label' => esc_html__( 'Button', 'conat' ),
            ]
        );
		$this->add_control(
            'btn_style',
            [
                'label' => esc_html__('Style', 'conat'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'one',
                'options' => conat_button_style(),
            ]
        );
        $this->add_control(
            'btn_name',
            [
                'label' => __( 'Name', 'conat' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Link', 'conat' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'conat' ),
                'show_external' => true,
                'dynamic'  => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        $this->end_controls_section();
    }
	
	/***********************************************
						Style Tab
	***********************************************/
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- About One -->
        <section class="about-one <?php if ($settings['style'] != 'yes') echo 'style-two'; ?>">
            <?php if($settings['left_pattern_image']['id']) { ?><div class="about-one_pattern-one" data-parallax='{"y" : 80}' style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['left_pattern_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['right_pattern_image']['id']) { ?><div class="about-one_pattern-two" data-parallax='{"y" : 120}' style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_pattern_image']['id'])); ?>)"></div><?php } ?>
            <?php if($settings['right_top_pattern']['id']) { ?><div class="about-one_pattern-three" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['right_top_pattern']['id'])); ?>)"></div><?php } ?>
            <div class="auto-container">
                <div class="row clearfix">
                    <!-- Image Column -->
                    <div class="about-one_image-column col-lg-6 col-md-12 col-sm-12">
                        <div class="about-one_image-inner">
                            <?php if($settings['pattern_image']['id']) { ?><div class="about-one_pattern-four" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image']['id'])); ?>)"></div><?php } ?>
                            
                            <?php if($settings['image']['id']) { ?>
                            <div class="about-one_image wow rollIn">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'conat'); ?>" />
                            </div>
                            <?php } ?>
                            
                            <?php if($settings['video_url']['url']) { ?>
                            <a href="<?php echo esc_url($settings['video_url']['url']); ?>" class="lightbox-video slider-one_play"><span class="fa fa-play"><i class="ripple"></i></span></a>
                            <?php } ?>
                        </div>
                    </div>
                    <!-- Content Column -->
                    <div class="about-one_content-column col-lg-6 col-md-12 col-sm-12">
                        <div class="about-one_content-inner">
                            <div class="sec-title title-anim">
                                <div class="sec-title_title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                                <h2 class="sec-title_heading"><?php echo wp_kses( $settings['title'], true ); ?></h2>
                            </div>
                            <div class="about-one_bold-text"><?php echo wp_kses( $settings['bold_text'], true ); ?></div>
                            <div class="about-one_text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                            
                            <?php if ($settings['features']){ ?>
                            <div class="row clearfix">
                            	<?php foreach($settings['features'] as $key => $item) { ?>
                                <!-- About One Block -->
                                <div class="about-one_block col-lg-6 col-md-6 col-sm-12">
                                    <div class="about-one_block-inner">
                                        <span class="about-one_block-icon <?php echo esc_attr($item['icon']); ?>"></span>
                                        <strong><?php echo wp_kses( $item['title'], true ); ?></strong>
                                        <?php echo wp_kses( $item['text'], true ); ?>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                            <?php } ?>
                            
                            <?php if($settings['btn_link']['url'] and $settings['btn_name']) { ?>
                            <div class="about-one_button">
                                <?php echo conat_button($settings['btn_style'], $settings['btn_name'], $settings['btn_link']['url']); ?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End About One -->
        
        <?php
    }
}
